<?php

namespace App;

use Mtc\Filter\FilterIndex;

class Filter extends \Mtc\Filter\Filter
{
    /**
     * Find the id of the slug
     *
     * @param string $model_type
     * @param $slug
     * @return int
     */
    public static function matchSlugToId(string $model_type, $slug)
    {
        return FilterIndex::query()
            ->where('filter_type', $model_type)
            ->where('slug', $slug)
            ->firstOrFail()
            ->filter_id;
    }

    /**
     * Parse Request to selections and filter data
     *
     * @return array
     */
    public function parseRequest(): array
    {
        $this->decodeRequest();

        return [
            'seo' => $this->getPageSeoData(),
            'selections' => $this->getSelectionList(),
            'sort_by' => $this->active_sort_option_name,
            'base_url' => url($this->config['url_entrypoint']),
            'page' => $this->request->input('page', 1),
        ];
    }

    /**
     * Handle Ajax request, perform filtering
     *
     * @return array
     */
    public function handle(): array
    {
        $this->request = request();
        $this->selections = $this->groupSelectionsByType(request()->input('selections', []));
        $this->run();

        return [
            'results' => $this->getResults(),
            'filters' => $this->getFilterResults(),
            'selections' => $this->getSelectionsWithNames(),
            'sort_options' => $this->getSortOptions(),
        ];
    }
}
