<?php

namespace App\Filter\Sorting;

use App\Facades\Settings;
use Illuminate\Database\Eloquent\Builder;
use Mtc\Filter\Contracts\IsSortOption;

class MileageAscending implements IsSortOption
{
    /**
     * Perform sorting query adjustments
     *
     * @param Builder $query
     * @return Builder
     */
    public function handle(Builder $query): Builder
    {
        $mileage_column = Settings::get('automotive.distance_measurement') === 'mi' ? 'odometer_mi' : 'odometer_km';
        return $query->orderBy($mileage_column);
    }
}
