<?php

namespace App\Http\Controllers;

use App\Http\Resources\MenuResource;
use App\Http\Resources\ThemeResource;
use Illuminate\Http\Request;
use Mtc\ContentManager\Models\Menu;

class LayoutController extends Controller
{
    /**
     * Show the layout of the site (header/footer/homepage?)
     *
     * @return ThemeResource
     */
    public function siteLayout(Request $request)
    {
        return  new ThemeResource(tenant());
    }

    /**
     * Display Navigation menu
     *
     * @param Menu $menu
     * @return MenuResource
     */
    public function showMenu(Menu $menu)
    {
        $menu->load('entries');
        return new MenuResource($menu);
    }
}
