<?php

namespace App\Http\Resources;

use Mtc\MercuryDataModels\Vehicle;
use Illuminate\Http\Resources\Json\ResourceCollection;

class FilterResultCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'current_page' => $this->currentPage(),
            'data' => $this->mapItems(),
            'first_page_url' => $this->url(1),
            'from' => $this->firstItem(),
            'last_page' => $this->lastPage(),
            'last_page_url' => $this->url($this->lastPage()),
            'next_page_url' => $this->nextPageUrl(),
            'path' => $this->path(),
            'per_page' => $this->perPage(),
            'prev_page_url' => $this->previousPageUrl(),
            'to' => $this->lastItem(),
            'total' => $this->total(),
        ];
    }

    private function mapItems()
    {
        return $this->collection
            ->map(fn($vehicle) => $this->map($vehicle));
    }

    public function map(Vehicle $vehicle)
    {
        return [
            'id' => $vehicle->id,
            'title' => $vehicle->title,
            'derivative' => $vehicle->derivative,
            'slug' => $vehicle->url_slug,
            'is_new' => $vehicle->is_new,
            'price' => $vehicle->price,
            'monthly_price' => $vehicle->monthly_price,
            'make_id' => $vehicle->make_id,
            'images' => [

            ],
            'make' => [
                'name' => $vehicle->make->name ?? '',
                'logo' => $vehicle->make->logo ?? '',
            ],
            'location' => $vehicle->dealership->name ?? '',
            'deposit' => $vehicle->deposit,
        ];
    }
}
