<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        // All content of the page is cached in the text field
        return $this->resource->only([
            'text',
            'meta',
            'seo',
            'slug',
            'title',
            'id',
        ]);
    }
}
