<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\ContentManager\Models\Menu;

class ThemeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'logo' => Settings::get('app.logo'),
            'colour-scheme' => 'default',
            'menus' => Menu::query()
                ->with('entries')
                // TODO: how to identify global menus vs page-specific menus
                ->get()
                ->map(fn (Menu $menu) => new MenuResource($menu)),
        ];
    }
}
