<?php

namespace Tests\Feature;

use App\Facades\Settings;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\TestCase;

class VehicleFilterSortingTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testSortByLatest()
    {
        $vehicle1 = Vehicle::factory()->create(['created_at' => Carbon::now()->subWeek()]);
        $vehicle2 = Vehicle::factory()->create(['created_at' => Carbon::now()->subDay()]);
        $vehicle3 = Vehicle::factory()->create(['created_at' => Carbon::now()]);

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'latest',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle3->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle2->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.2.id'));
    }

    public function testSortByPriceAsc()
    {
        $vehicle1 = Vehicle::factory()->create(['price' => 10200]);
        $vehicle2 = Vehicle::factory()->create(['price' => 24000]);
        $vehicle3 = Vehicle::factory()->create(['price' => 8900]);

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'price-asc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle3->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle2->id, $response->json('results.data.2.id'));

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'price-desc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle2->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle3->id, $response->json('results.data.2.id'));
    }

    public function testSortByMonthlyPriceAsc()
    {
        $vehicle1 = Vehicle::factory()->create(['monthly_price' => 123]);
        $vehicle2 = Vehicle::factory()->create(['monthly_price' => 321]);
        $vehicle3 = Vehicle::factory()->create(['monthly_price' => 222]);

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'monthly-price-asc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle1->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle3->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle2->id, $response->json('results.data.2.id'));

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'monthly-price-desc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle2->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle3->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.2.id'));
    }

    public function testSortByMileageAsc()
    {
        Settings::make([
            'section' => 'automotive',
            'group' => 'General',
            'name' => 'Distance measurement',
            'config_key' => 'automotive.distance_measurement',
            'type' => 'string',
            'value' => 'mi',
        ]);

        $vehicle1 = Vehicle::factory()->create(['odometer_mi' => 50000]);
        $vehicle2 = Vehicle::factory()->create(['odometer_mi' => 65000]);
        $vehicle3 = Vehicle::factory()->create(['odometer_mi' => 60000]);

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'mileage-asc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle1->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle3->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle2->id, $response->json('results.data.2.id'));

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'mileage-desc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle2->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle3->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.2.id'));
    }

    public function testSortByAgeAsc()
    {
        $vehicle1 = Vehicle::factory()->create(['manufacture_year' => 2020]);
        $vehicle2 = Vehicle::factory()->create(['manufacture_year' => 2018]);
        $vehicle3 = Vehicle::factory()->create(['manufacture_year' => 2021]);

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'age-asc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle2->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle3->id, $response->json('results.data.2.id'));

        $response = $this->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('vehicles.index'), [
                'sort_by' => 'age-desc',
            ]);

        $response->assertStatus(200);
        $this->assertEquals($vehicle3->id, $response->json('results.data.0.id'));
        $this->assertEquals($vehicle1->id, $response->json('results.data.1.id'));
        $this->assertEquals($vehicle2->id, $response->json('results.data.2.id'));
    }
}
