<?php

namespace App\Facades;

use App\SiteRepository;
use Illuminate\Support\Facades\Facade;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

/**
 * @method static string url(string $endpoint)
 * @method static string vehicleUrl(Vehicle $vehicle)
 * @method static string offerUrl(VehicleOffer $offer)
 * @method static string newCarUrl(NewCar $car)
 * @method static string dealershipUrl(Dealership $dealership)
 * @see SiteRepository
 */
class Site extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'site-repository';
    }
}
