<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\SeoRedirect;

class SeoRedirectCheckMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (($redirect = $this->checkRedirect($request)) !== null) {
            return response([
                'type' => 'redirect',
                'to' => $redirect->toValue(),
                'code' => $redirect->code
            ], 404);
        }
        return $next($request);
    }

    /**
     * @param Request $request
     * @return Model|SeoRedirect|null
     */
    private function checkRedirect(Request $request): ?SeoRedirect
    {
        $redirect = SeoRedirect::query()
            ->where('from', $request->header('x-path'))
            ->first();

        $domain = str_replace('www.', '', $request->header('x-tenant'));
        if (!$redirect) {
            $redirect = SeoRedirect::query()
                ->where('from_domain', 'like', '%' . $domain)
                ->where('from', '*')
                ->first();
        }

        if (empty($redirect->from_domain)) {
            return $redirect;
        }
        $domain_matches = $domain == str_replace('www.', '', $redirect->from_domain);

        return $domain_matches ? $redirect : null;
    }
}
