<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Models\MediaSize;

trait MediaHasSizes
{
    private function allSizesForUse(Model $model, MediaUse $mediaUse): Collection
    {
        $mediaSizes = Cache::remember(
            tenant('id') . '-media-sizes-' . $mediaUse->getOwnerType(),
            now()->addHour(),
            fn() => MediaSize::query()->where('model', $mediaUse->getOwnerType())->get()
        );

        if (is_array($mediaSizes)) {
            $mediaSizes = collect($mediaSizes)->map(function ($size) {
                return is_array($size)
                    ? new MediaSize($size)
                    : $size;
            });
        }

        $this->mediaSizes = $mediaSizes;

        return $this->mediaSizes
            ->keyBy('label')
            ->map(fn(MediaSize $size) => $mediaUse->getUrl($size->label));
    }
}
