<?php

namespace Tests;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferFilterSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->getData() as $setting) {
            Settings::make($setting);
        }
    }

    private function getData(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Make',
                'config_key' => 'automotive-vehicle-filters-offer-make',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Make',
                'config_key' => 'filter-apply-selections-to-results',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Model',
                'config_key' => 'automotive-vehicle-filters-offer-model',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Max',
                'config_key' => 'automotive-vehicle-filters-offer-price_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Min',
                'config_key' => 'automotive-vehicle-filters-offer-price_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Monthly Max',
                'config_key' => 'automotive-vehicle-filters-offer-price_monthly_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price Monthly Min',
                'config_key' => 'automotive-vehicle-filters-offer-price_monthly_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Location',
                'config_key' => 'automotive-vehicle-filters-offer-location',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Colour',
                'config_key' => 'automotive-vehicle-filters-offer-colour',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Body Style',
                'config_key' => 'automotive-vehicle-filters-offer-body_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Fuel Type',
                'config_key' => 'automotive-vehicle-filters-offer-fuel_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Transmission Type',
                'config_key' => 'automotive-vehicle-filters-offer-transmission',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Offer Type',
                'config_key' => 'automotive-vehicle-filters-offer_type',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
