<?php

namespace Tests\Feature;

use App\Facades\Settings;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class RestrictedAccessTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testVehicleAction()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'site-access-enabled',
            'value' => false,
            'type' => 'boolean',
        ]);

        $response = $this->asTenant(tenant())->getJson(route('get-site'));
        $response->assertStatus(200);

        $this->assertArrayHasKey('restricted_access', $response->json());
        $this->assertFalse($response->json('restricted_access'));

        Settings::update('site-access-enabled', true);
        $response = $this->asTenant(tenant())->getJson(route('get-site'));
        $this->assertTrue($response->json('restricted_access'));
    }

    public function testCheckAccess()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'site-access-password',
            'value' => 'foo-baz-bar',
            'type' => 'secret',
        ]);

        $response = $this->asTenant(tenant())
            ->postJson(route('check-site-access'), [
                'password' => 'lorem-ipsum',
            ]);

        $response->assertStatus(403);

        $response = $this->asTenant(tenant())
            ->postJson(route('check-site-access'), [
                'password' => 'foo-baz-bar',
            ]);

        $response->assertStatus(200);
    }
}
