<?php

namespace App\Contracts;

abstract class SeoKeywordMapper
{
    /**
     * Map Seo Keywords from defaults to end string
     *
     * @param string $inputString
     * @return string
     */
    public function map(string $inputString): string
    {
        preg_match_all("/{{([A-Z_]+)}}/", $inputString, $matches);
        if (empty($matches[0])) {
            return $inputString;
        }

        foreach ($matches[0] as $index => $termToReplace) {
            $inputString = str_replace($termToReplace, $this->mapKeyWord($matches[1][$index]), $inputString);
        }

        return $inputString;
    }

    abstract protected function mapKeyWord(string $keyword): string;
}
