<?php

namespace App\Http\Controllers;

use App\Filter;
use App\Http\Requests\OfferSearchRequest;
use App\Http\Resources\OfferListResource;
use App\Http\Resources\OfferResource;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferController extends Controller
{
    public function index(OfferSearchRequest $request, string $make)
    {
        $offers = VehicleOffer::query()
            ->where('make_id', Filter::matchSlugToId('make', $make))
            ->when($request->filled('model_id'), fn ($query) => $query->where('model_id', $request->input('model_id')))
            ->when($request->filled('sort'), fn ($query) => $query->setSortBy($request->input('sort')))
            ->active()
            ->paginate();
        return new OfferListResource($offers);
    }

    /**
     * Show vehicle FPA details
     *
     * @param Vehicle $vehicle
     * @return OfferResource
     */
    public function show(VehicleOffer $offer)
    {
        return new OfferResource($offer);
    }
}
