<?php

namespace App\Http\Controllers;

use App\Http\Resources\VehicleResource;
use Mtc\MercuryDataModels\Vehicle;
use App\Repositories\RecentlyViewed;

class VehicleController extends Controller
{
    /**
     * Show vehicle FPA details
     *
     * @param Vehicle $vehicle
     * @return VehicleResource
     */
    public function show(Vehicle $vehicle, RecentlyViewed $recentlyViewed)
    {
        $recentlyViewed->add('vehicles', $vehicle->id);
        return new VehicleResource($vehicle);
    }
}
