<?php

namespace App\Http\Resources;

use App\HasSeoData;
use App\Seo\OfferSeoDataMap;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferResource extends JsonResource
{
    use HasSeoData;

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->seo = $this->getSeoData(
            $request->path(),
            'offer',
            (new OfferSeoDataMap($this->resource))
        );
        return parent::toArray($request);
    }
}
