<?php

namespace App\Http\Resources;

use App\HasSeoData;
use App\Seo\PageSeoDataMap;
use Illuminate\Http\Resources\Json\JsonResource;

class PageResource extends JsonResource
{
    use HasSeoData;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->seo = $this->getSeoData(
            $request->path(),
            'page',
            (new PageSeoDataMap($this->resource))
        );
        return parent::toArray($request);
    }
}
