<?php

namespace App\Http\Resources;

use App\HasSeoData;
use App\Seo\VehicleSeoDataMap;
use Illuminate\Http\Resources\Json\JsonResource;

class VehicleResource extends JsonResource
{
    use HasSeoData;

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->seo = $this->getSeoData(
            $request->path(),
            'vehicle',
            (new VehicleSeoDataMap($this->resource))
        );
        return parent::toArray($request);
    }
}
