<?php

namespace App\Seo;

use App\Contracts\SeoKeywordMapper;
use App\Facades\Settings;
use App\Filter;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Vehicle;

class FilterSeoDataMap extends SeoKeywordMapper
{
    public function __construct(private readonly Filter $vehicle)
    {
        //
    }
    /**
     * Map keywords against model data
     *
     * @param string $keyword
     * @return string
     */
    protected function mapKeyWord(string $keyword): string
    {
        return match($keyword) {
            'SITE_NAME' => Settings::get('app.name') ?? '',
            'CONTENT_EXCERPT' => Str::limit('', 147),
            default => '',
        };
    }
}
