<?php

namespace App\Seo;

use App\Contracts\SeoKeywordMapper;
use App\Facades\Settings;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferSeoDataMap extends SeoKeywordMapper
{
    public function __construct(private readonly VehicleOffer $offer)
    {
        //
    }

    /**
     * Map keywords against model data
     *
     * @param string $keyword
     * @return string
     */
    protected function mapKeyWord(string $keyword): string
    {
        return match($keyword) {
            'TITLE' => $this->offer->name,
            'MAKE' => $this->offer?->make?->name ?? '',
            'MODEL' => $this->offer?->model?->name ?? '',
            'SITE_NAME' => Settings::get('app.name') ?? '',
            'CONTENT_EXCERPT' => Str::limit(strip_tags($this->offer->description), 147),
            default => '',
        };
    }
}
