<?php

namespace App\Seo;

use App\Contracts\SeoKeywordMapper;
use App\Facades\Settings;
use Illuminate\Support\Str;
use Mtc\ContentManager\Contracts\PageModel;

class PageSeoDataMap extends SeoKeywordMapper
{
    /**
     * @param PageModel $page
     */
    public function __construct(private readonly PageModel $page)
    {
        //
    }

    /**
     * Map keywords against model data
     *
     * @param string $keyword
     * @return string
     */
    protected function mapKeyWord(string $keyword): string
    {
        return match($keyword) {
            'TITLE' => $this->page->title,
            'SITE_NAME' => Settings::get('app.name') ?? '',
            'CONTENT_EXCERPT' => Str::limit(strip_tags($this->page->search_content), 147),
            default => '',
        };
    }
}
