<?php

namespace App\Seo;

use App\Contracts\SeoKeywordMapper;
use App\Facades\Settings;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Vehicle;

class VehicleSeoDataMap extends SeoKeywordMapper
{
    /**
     * @param Vehicle $vehicle
     */
    public function __construct(private readonly Vehicle $vehicle)
    {
        //
    }

    /**
     * Map keywords against model data
     *
     * @param string $keyword
     * @return string
     */
    protected function mapKeyWord(string $keyword): string
    {
        return match($keyword) {
            'TITLE' => $this->vehicle->title,
            'MAKE' => $this->vehicle?->make?->name ?? '',
            'MODEL' => $this->vehicle?->model?->name ?? '',
            'YEAR' => $this->vehicle?->manufacture_year ?? '',
            'SITE_NAME' => Settings::get('app.name') ?? '',
            'CONTENT_EXCERPT' => Str::limit(strip_tags($this->vehicle->description), 147),
            default => '',
        };
    }
}
