<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Setting;

class SettingRepository
{
    /**
     * List of loaded settings
     *
     * @var mixed[]
     */
    private array $loaded_settings = [];

    /**
     * @param array $setting
     * @return Setting|Model
     */
    public function make(array $setting): Setting
    {
        return Setting::query()
            ->updateOrCreate([
                'section' => $setting['section'],
                'group' => $setting['group'],
                'name' => $setting['name'],
                'config_key' => $setting['config_key'],
                'type' => $setting['type'],
                'value' => $setting['value'],
            ]);
    }
    /**
     * Get a setting
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key, $default = null)
    {
        if (!isset($this->loaded_settings[$key])) {
            $this->loaded_settings[$key] = Setting::query()
                    ->where('config_key', $key)
                    ->first()
                    ?->value ?? $default;
        }

        return $this->loaded_settings[$key];
    }

    /**
     * Get a setting
     *
     * @param string $key
     * @return mixed
     */
    public function update(string $key, $value)
    {
        Setting::query()
            ->where('config_key', $key)
            ->update([
                'value' => $value,
            ]);

        if (isset($this->loaded_settings[$key])) {
            unset($this->loaded_settings[$key]);
        }
    }
}
