<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Overload migrations/routes
    |--------------------------------------------------------------------------
    |
    | Allows disabling default migration/route workflows to set up custom ones
    |
    */
    'load_routes' => false,
    'load_migrations' => false,

    /*
    |--------------------------------------------------------------------------
    | Filter Instance
    |--------------------------------------------------------------------------
    |
    | This class will be used to perform filtering in system. It has been
    | so it can be changed, but necessity for it should be small
    | as all aspects like filters, object being filtered, sorting and other
    | elements can be managed through other config options
    |
    */
    'filter_instance' => \App\Filter::class,

    /*
    |--------------------------------------------------------------------------
    | Filters
    |--------------------------------------------------------------------------
    |
    | These are the filters that will be passed down to site. Each filter
    | carries out actions for applying selections, fetching filter choices
    | and other aspects to ensure easy integration in the system. Filter
    | needs to be an instance/extension of IsFilter class.
    | When generating URL filters will be sorted in order listed how they are
    | ordered here (e.g. category/brand/size or /category/category/size)
    |
    */
    'filters' => [
        'make' => \App\Filters\MakeFilter::class,
        'model' => \App\Filters\ModelFilter::class,
        'body_type' => \App\Filters\BodyTypeFilter::class,
        'price' => \App\Filters\PriceFilter::class,
        'age' => \App\Filters\AgeFilter::class,
        'colour' => \App\Filters\ColourFilter::class,
        'door_count' => \App\Filters\DoorFilter::class,
        'engine_size' => \App\Filters\EngineSizeFilter::class,
        'fuel_type' => \App\Filters\FuelTypeFilter::class,
        'transmission' => \App\Filters\TransmissionFilter::class,
        'location' => \App\Filters\LocationFilter::class,
        'mileage' => \App\Filters\MileageFilter::class,
        'seats' => \App\Filters\SeatFilter::class,
        'search' => \App\Filters\SearchTermFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Filtered Object Class
    |--------------------------------------------------------------------------
    |
    | This is the class that specifies how the filtered object (Product)
    | should be filtered and how to format its results.
    |
    */
    'filter_object' => \App\VehicleFilter::class,

    /*
    |--------------------------------------------------------------------------
    | Result Sorting
    |--------------------------------------------------------------------------
    |
    | Sort options available on site. Each class specifies how to order
    | results for the constructed query.
    |
    */

    'sort_options' => [
        'latest' => \Mtc\Filter\Sorting\NewArrivals::class,
        'price-desc' => \App\Filter\Sorting\PriceDescending::class,
        'price-asc' => \App\Filter\Sorting\PriceAscending::class,
        'monthly-price-desc' => \App\Filter\Sorting\MonthlyPriceDescending::class,
        'monthly-price-asc' => \App\Filter\Sorting\MonthlyPriceAscending::class,
        'mileage-desc' => \App\Filter\Sorting\MileageDescending::class,
        'mileage-asc' => \App\Filter\Sorting\MileageAscending::class,
        'age-desc' => \App\Filter\Sorting\AgeDescending::class,
        'age-asc' => \App\Filter\Sorting\AgeAscending::class,
    ],
];
