<?php

declare(strict_types=1);

use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\LayoutController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\VehicleController;
use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Stancl\Tenancy\Middleware\InitializeTenancyByRequestData;
use Stancl\Tenancy\Middleware\PreventAccessFromCentralDomains;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'api',
//    InitializeTenancyByDomain::class,
    InitializeTenancyByRequestData::class,
//    PreventAccessFromCentralDomains::class,
    PreventRequestsIfTenantSuspended::class
])->prefix('frontend/')->group(function (Router $router) {

    $router->post('/newsletter', [NewsletterController::class, 'store'])->name('newsletter-signup');
    $router->post('/enquiries', [EnquiryController::class, 'store'])->name('enquiries.store');
    $router->get('/pages/{page}', [PageController::class, 'show'])->name('pages.show');
    $router->get('/layout/site-layout', [LayoutController::class, 'siteLayout'])->name('layout.index');
    $router->get('/layout/menus/{menu}', [LayoutController::class, 'showMenu'])->name('layout.menu');

    $router->post('/find-vehicle', [FilterController::class, 'index'])->name('vehicles.index');
    $router->get('/vehicles/{vehicle:slug}', [VehicleController::class, 'show'])->name('vehicles.show');

    $router->post('/offers/{make}', [OfferController::class, 'index'])->name('offers.index');
    $router->get('/offers/{offer}', [OfferController::class, 'show'])->name('offers.show');

});
