<?php

namespace Tests;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->getData() as $setting) {
            Settings::make($setting);
        }
    }

    private function getData(): array
    {
        return [
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Vehicle Make',
                'config_key' => 'automotive.vehicle-filters.make',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Vehicle Model',
                'config_key' => 'automotive.vehicle-filters.model',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Body Type',
                'config_key' => 'automotive.vehicle-filters.body_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Price',
                'config_key' => 'automotive.vehicle-filters.price',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Model Year',
                'config_key' => 'automotive.vehicle-filters.age',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Colour',
                'config_key' => 'automotive.vehicle-filters.colour',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Door Count',
                'config_key' => 'automotive.vehicle-filters.door_count',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Engine Size',
                'config_key' => 'automotive.vehicle-filters.engine_size',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Fuel Type',
                'config_key' => 'automotive.vehicle-filters.fuel_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Transmission',
                'config_key' => 'automotive.vehicle-filters.transmission',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Location',
                'config_key' => 'automotive.vehicle-filters.location',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Mileage',
                'config_key' => 'automotive.vehicle-filters.mileage',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Seat Count',
                'config_key' => 'automotive.vehicle-filters.seats',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Search by term',
                'config_key' => 'automotive.vehicle-filters.search',
                'type' => 'boolean',
                'value' => true,
            ],

        ];
    }
}
