<?php

namespace Tests;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SortingSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->getData() as $setting) {
            Settings::make($setting);
        }
    }

    private function getData(): array
    {
        return [
            [
                'section' => 'automotive',
                'group' => 'Filter Sorting',
                'name' => 'Most Recent',
                'config_key' => 'automotive.vehicle-sorting.latest',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Price Descending',
                'config_key' => 'automotive.vehicle-sorting.price-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Price Ascending',
                'config_key' => 'automotive.vehicle-sorting.price-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Monthly Price Descending',
                'config_key' => 'automotive.vehicle-sorting.monthly-price-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Monthly Price Ascending',
                'config_key' => 'automotive.vehicle-sorting.monthly-price-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Mileage Descending',
                'config_key' => 'automotive.vehicle-sorting.mileage-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Mileage Ascending',
                'config_key' => 'automotive.vehicle-sorting.mileage-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Manufacture Year Ascending',
                'config_key' => 'automotive.vehicle-sorting.age-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'section' => 'automotive',
                'group' => 'Filters',
                'name' => 'Manufacture Year Descending',
                'config_key' => 'automotive.vehicle-sorting.age-desc',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
