<?php

namespace App\Http\Requests;

use App\Tier;
use App\TierHelper;
use Illuminate\Foundation\Http\FormRequest;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationCustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return TierHelper::isAllowed(tenant('tier'), Tier::PRO->value)
            && Valuation::hasEnabledDriver();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'valuation_id' => 'required',
            'first_name' => 'required',
            'last_name' => 'required',
            'phone' => 'required',
            'postcode' => 'required',
            'email' => [
                'required',
                'email',
            ],
        ];
    }
}
