<?php

namespace App\Contracts;

interface NewsletterProvider
{
    /**
     * Sign up method
     *
     * @param string $email email address to sign up
     * @param array $additional_params any additional params passed to interface
     * @return bool
     */
    public function signUp(string $email, array $additional_params = []): bool;

    /**
     * Check if email already exists in the list
     *
     * @param string $email
     * @return bool
     */
    public function checkIfExists(string $email): bool;
}
