<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use App\Traits\MapElementBasedContent;
use App\Traits\RetrievesSeoData;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Mtc\ContentManager\Http\Resources\MediaEntryResource;
use Mtc\MercuryDataModels\CarConfiguratorModel;
use Mtc\MercuryDataModels\CarConfiguratorRestriction;
use Mtc\MercuryDataModels\CarConfiguratorSection;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\MediaUse;
use Mtc\MercuryDataModels\VehicleOffer;

class ConfiguratorList extends JsonResource
{
    use MapElementBasedContent;
    use RetrievesSeoData;

    private readonly Request $request;
    private array $sections = [];
    private array $saved_selections = [];
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return $this->resource->map(function (CarConfiguratorModel $model) {
            $data = [
                'slug' => $model->slug,
                'name' => $model->name,
            ];

            /** @var MediaUse $mediaUse */
            $mediaUse = $model->mediaUses()
                ->where('order', 0)
                ->where('flags', 'like', '%exterior%')
                ->inRandomOrder()
                ->first();
            if ($mediaUse) {
                $data['media_uses'] = [
                    [
                        'id' => $mediaUse->id,
                        'hex1' => $mediaUse->media->hex1,
                        'hex2' => $mediaUse->media->hex2,
                        'title' => $mediaUse->title,
                        'alt_text' => $mediaUse->alt_text,
                        'description' => $mediaUse->description,
                        'caption' => $mediaUse->caption,
                        'type' => $mediaUse->media->type,
                        'original' => $mediaUse->media->getOriginalUrlAttribute(),
                        'sizes' => $this->allSizesForUse($model, $mediaUse, 'car-config-model'),
                    ]
                ];
            }
            return $data;
        })->toArray();
    }
}
