<?php

namespace Tests;

use Database\Seeders\Global\GlobalRoleSeed;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Mtc\MercuryDataModels\Contracts\FeatureFlag;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\TenantFeature;
use Mtc\MercuryDataModels\User;

class TestFeatureRepository
{
    private array $flags = [];

    public function isEnabled(string $feature): bool
    {
        return $this->flags[$feature] ?? false;
    }

    public function getAll(): Collection
    {
        return collect(config('features.all'));
    }

    public function enabledForTenant(): Collection
    {
        return collect(config('features.all', []))
            ->filter(fn($class, $feature) => class_exists($class) && array_key_exists($feature, $this->flags))
            ->map(fn ($class, $feature) => App::make($class))
            ->filter(fn($class) => $class instanceof FeatureFlag);
    }

    public function setEnabled(Tenant $tenant, array $features): void
    {
        collect($features)
            ->each(function ($feature) use ($tenant) {
                if (isset($this->flags[$feature])) {
                    unset($this->flags[$feature]);
                } else {
                    $this->flags[$feature] = true;
                }
            });
    }
}
