<?php

namespace App\Http\Controllers;

use App\Http\Requests\LookupRequest;
use App\Http\Resources\LookupResource;
use Mtc\VehicleLookup\VehicleLookupService;

class LookupController extends Controller
{
    public function __invoke(LookupRequest $request, VehicleLookupService $lookupService)
    {
        $lookup = $lookupService->findByVRM(
            $request->input('registration_number'),
            $request->input('mileage')
        );

        return new LookupResource($lookup);
    }
}
