<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\MercuryDataModels\NewCar;

class ViewNewCarRequest extends FormRequest
{
    private NewCar $model;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->public() || $this->withAccessKey();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            //
        ];
    }

    private function public(): bool
    {
        return $this->car?->published ?? false;
    }

    private function withAccessKey(): bool
    {
        return $this->input('a') === base64_encode($this->car?->id . '-' . $this->car?->slug);
    }
}
