<?php

namespace App;

use Mtc\MercuryDataModels\ValuationAdjustment;
use Mtc\MercuryDataModels\VehicleValuation;
use Illuminate\Database\Eloquent\Builder;
use Mtc\VehicleValuation\Contracts\ValuationResponse;

class ValuationRepository extends \Mtc\VehicleValuation\ValuationRepository
{
    protected function getQuery(): Builder
    {
        return VehicleValuation::query();
    }

    /**
     * Store a valuation result from API
     *
     * @param ValuationResponse $valuation_response
     * @return Builder|Model
     */
    protected function store(ValuationResponse $valuation_response): ?VehicleValuation
    {
        $valuation = parent::store($valuation_response);

        if (
            empty($valuation)
            || (
                empty($valuation['retail_price'])
                && empty($valuation['average_price'])
                && empty($valuation['clean_price'])
                && empty($valuation['below_price'])
                && !empty($valuation['data'])
            )
        ) {
            return $valuation;
        }

        return $this->adjustValuation($valuation);
    }

    protected function adjustValuation($valuation)
    {
        $valuationAdjustments = ValuationAdjustment::query()
            ->with('rules')
            ->active()
            ->get();

        foreach ($valuationAdjustments as $valuationAdjustment) {
            if ($valuationAdjustment->evaluate($valuation)) {
                $valuation->adjust($valuationAdjustment);
                break;
            }
        }

        return $valuation;
    }
}
