<?php

namespace Mtc\BankTransfer\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\BankTransfer\BankTransfer;

/**
 * Class BankTransferServiceProvider
 *
 * @package Mtc\BankTransfer
 */
class BankTransferServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if (config('bank_transfer.enabled', false) === false) {
            return;
        }

        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'bank_transfer');
        $this->app['payment']->extend('bank-transfer', function($app) {
            return new BankTransfer();
        });

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/bank_transfer.php' => config_path('bank_transfer.php'),
            ], 'config');

            $this->publishes([
                \dirname(__DIR__, 2) . '/resources/templates' => public_path('templates'),
            ], 'templates');

        } else {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/bank_transfer.php', 'bank_transfer');

    }

}
