<?php


namespace Mtc\BarclaycardEPDQ\Providers;


use Illuminate\Support\ServiceProvider;
use Mtc\BarclaycardEPDQ\BarclaycardEPDQ;

class BarclaycardEPDQServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/barclaycard-epdq.php', 'barclaycard-epdq');
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'barclaycard-epdq');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        
        $this->app['payment']->extend('barclaycard-epdq', function ($app) {
            return new BarclaycardEPDQ();
        });

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/barclaycard-epdq.php' => config_path('barclaycard-epdq.php'),
            ], 'config');

            // Publishing the translation files.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/barclaycard-epdq'),
            ], 'lang');

        }
    }
}