# Basket Recovery

The basket recovery package has been created to work with the basket and order-management packages for core, these are pulled in as a dependency. This module enables the administrator of the system to notify any abandoned baskets with a bespoke email using a date interval, this could be every hour, every day ,every week or month.

Customers can only be notified if they have accepted the newsletter_signup and have provided their email within a basket or order.

## Installation

To install this package via composer, you must have the MTC composer repository within your composer.json, what this does is give your application the ability to access any MTC specific packages for core, namely basket, order-mangement and basket-recovery.

**Please note, this package has been built upon CORE and requires Laravel 5.7**

There are areas within the package which depend on core and therefore aren't able to be tested until components are taken out into their own packages. The functionality which does not have feature or unit tests are: Admin, Notify Basket Command and Installation Command.

[MTC Composer Private Packagist](https://composer.mtcassets.com)

Within your composer.json please apply the following to "repositories"

```json
{
  "repositories": [
    ...
    {
      "type": "composer",
      "url": "https://composer.mtcassets.com/"
    }
  ]
}
```

Then run the following command to include this package in your application.
*Please note this is also pulls in the order-management, basket and money packages.*

```bash
composer require mtcmedia/basket-recovery
```

Once the package has been installed, the auto-discovery provided since Laravel 5.5 will include the BasketServiceProvider. This registers the following commands:

```bash
php artisan basket-recovery:install
php artisan basket-recovery:notify
```

## Basket Notification Command

The basket notification command is registered with the scheduler by default once the package has been included.
Please ensure the cron for `php artisan schedule:run` has been setup.

### Testing

When contributing any changes to this package PLEASE write tests for the functionality where possible, and run the tests before submitting a pull request to ensure that present functionality is not broken.

``` bash
composer test
```

### Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information what has changed recently.

### Security

If you discover any security related issues, please email liam.jackson@mtcmedia.co.uk instead of using the issue tracker.

## Credits

- [Liam Jackson](https://github.com/ljjackson)
- [All Contributors](../../contributors)

## Roadmap

Any feature requests which are deemed required or will provide benefits will be noted here. Open for anyone to contribute to.

- [ ] To enable testability of admin area, we need to ensure that MTC\Core\Http\Controllers\Controller is ported into it's own package. This will allow for testability as every Administration controller relies on this.

- [ ] To enable testing of email sending, we need to move over to native Laravel emails.