<?php

namespace Mtc\BasketRecovery\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class BasketRecoveryRequest
 *
 * @package Mtc\BasketRecovery\Http\Requests
 */
class BasketRecoveryRequest extends FormRequest
{

    /**
     * If the basket recovery fails, send them to the homepage.
     *
     * @var string
     */
    protected $redirect = '/';

    /**
     * @return array
     */
    public function rules()
    {
        return [
            'token' => 'required',
        ];
    }

    /**
     * @return array
     */
    public function messages()
    {
        return parent::messages();
    }


    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @return string
     */
    public function getRedirect()
    {
        return $this->getRedirectUrl();
    }


}