<?php

namespace Mtc\BasketRecovery\Listeners;


use Mtc\BasketRecovery\Models\BasketRecoveryLog;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class LogOrderPaid
 *
 * @package Mtc\BasketRecovery\Listeners
 */
class LogOrderPaid
{

    /**
     * @param \Mtc\Orders\Events\OrderPaid $event
     */
    public function handle(OrderPaid $event)
    {

        /** @var \Mtc\Basket\Basket $basket */
        $basket = $event->getOrder()->basket()->first();

        /** @var BasketRecoveryLog $log */
        $log = BasketRecoveryLog::query()
            ->where('basket_id', $basket->id)
            ->where('action', 'click')
            ->first();

        // No recovery logs have been found, which means the user did NOT click / read the link.
        if (is_null($log) || is_null($log->basketRecovery)) {
            return;
        }

        BasketRecoveryLog::create($log->basket, $log->basketRecovery, 'sale', $event->getOrder()->cost_total->original());

    }

}
