<?php

namespace Mtc\BasketRecovery\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Database\Eloquent\Factory as EloquentFactory;
use Illuminate\Support\ServiceProvider;
use Mtc\BasketRecovery\Console\Commands\InstallCommand;
use Mtc\BasketRecovery\Console\Commands\NotifyAbandonedBasketsCommand;
use Mtc\BasketRecovery\Models\BasketRecovery;
use Mtc\BasketRecovery\Observers\BasketRecoveryObserver;

/**
 * Class BasketRecoveryServiceProvider
 *
 * @package Mtc\BasketRecovery\Providers
 */
class BasketRecoveryServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        BasketRecovery::observe(BasketRecoveryObserver::class);

        $this->setupTestEnvironment();
        $this->setupConsoleEnvironment();
    }

    /**
     * Set up stuff for tests
     */
    public function setupTestEnvironment(): void
    {
        if (!$this->app->runningUnitTests()) {
            return;
        }

        $this->app['config']->set('basket-recovery.coupons.enabled', false);
    }

    /**
     * Set up Artisan functionality
     */
    public function setupConsoleEnvironment()
    {
        if (!$this->app->runningInConsole()) {
            return;
        }

        $this->publishes([
            __DIR__ . '/../../config/config.php' => config_path('basket-recovery.php'),
        ], 'config');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/js/' => resource_path('js/vendor')
        ], 'assets');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/less/' => resource_path('less/vendor')
        ], 'assets');

        // Registering package commands.
        $this->commands([
            InstallCommand::class,
            NotifyAbandonedBasketsCommand::class
        ]);
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2). '/config/basket_recovery.php', 'basket_recovery');

        collect(config('basket_recovery.service_providers', []))
            ->each(function ($service_provider) {
                $this->app->register($service_provider);
            });
        $this->registerEloquentFactories(__DIR__ . '/../../database/factories');
    }

    /**
     * @param $path
     */
    protected function registerEloquentFactories($path)
    {
        $this->app->make(EloquentFactory::class)->load($path);
    }

}