<?php namespace Mtc\BasketRecovery\Console\Commands;

use Illuminate\Console\Command;
use Mtc\BasketRecovery\Providers\BasketRecoveryServiceProvider;
use Mtc\BasketRecovery\Seeders\AdminNavigationSeeder;

/**
 * Class InstallCommand
 *
 * @package Mtc\BasketRecovery\Console
 */
class InstallCommand extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'basket-recovery:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install the basket recovery module.';

    /**
     * @return void
     */
    public function handle()
    {
        $this->installMigrations();
        $this->seedAdminMenu();
        $this->publishAssets();
    }

    /**
     * @return void
     */
    public function installMigrations(): void
    {
        $this->info('Setup migrations.');
        $this->callSilent('migrate');
    }

    /**
     * @return void
     */
    public function seedAdminMenu(): void
    {
        $this->info('Seeding administration menu.');
        $this->callSilent('db:seed', [
            '--class' => AdminNavigationSeeder::class
        ]);
    }

    /**
     * @return void
     */
    public function publishAssets(): void
    {

        $this->info("Publish assets.");
        $this->callSilent('vendor:publish', [
            '--provider' => BasketRecoveryServiceProvider::class,
            '--force'
        ]);

    }

}