<?php

namespace Mtc\BasketRecovery\Models;

use Illuminate\Database\Eloquent\Model;
use Mtc\Basket\Basket;

/**
 * Class BasketRecoveryLog
 *
 * @property integer $id
 * @property integer $basket_id
 * @property integer $basket_recovery_id
 * @property string $action
 * @property string|null $value
 * @property-read \Mtc\BasketRecovery\Models\BasketRecovery $basketRecovery
 * @property-read \Mtc\Basket\Basket $basket
 *
 * @package Mtc\BasketRecovery\Models
 */
class BasketRecoveryLog extends Model
{

    /**
     * @var string
     */
    protected $table = 'basket_recovery_logs';

    /**
     * @var array
     */
    protected $fillable = [
        'basket_id',
        'basket_recovery_id',
        'action',
        'value'
    ];

    /**
     * @param \Mtc\Basket\Basket $basket
     * @param \Mtc\BasketRecovery\Models\BasketRecovery $recovery
     * @param $action
     * @param null $value
     *
     * @return \Mtc\BasketRecovery\Models\BasketRecoveryLog
     */
    public static function create(Basket $basket, BasketRecovery $recovery, $action, $value = null)
    {
        $log = new self(compact('action', 'value'));
        $log->basket()->associate($basket);
        $log->basketRecovery()->associate($recovery);
        $log->save();
        return $log;
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(config('basket.model', Basket::class), 'basket_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basketRecovery()
    {
        return $this->belongsTo(BasketRecovery::class, 'basket_recovery_id');
    }

}