<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBasketRecoveryTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('basket_recoveries', function (Blueprint $table) {
            $table->increments('id');
            $table->string('interval');
            $table->integer('interval_seconds')->unsigned();
            $table->string('subject');
            $table->text('content');
            $table->text('coupon_data')->nullable();
            $table->boolean('is_active');
            $table->timestamps();
        });

        Schema::create('basket_recovery_logs', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('basket_recovery_id')->unsigned();
            $table->integer('basket_id')->unsigned();
            $table->string('action');
            $table->string('value')->nullable();
            $table->timestamps();

            $table->foreign('basket_recovery_id')->references('id')->on('basket_recoveries');
            $table->foreign('basket_id')->references('id')->on('baskets');
            $table->index('basket_id');
            $table->index('action');

        });

        Schema::create('basket_recovery_sent_emails', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('basket_id')->unsigned();
            $table->integer('basket_recovery_id')->unsigned()->nullable();
            $table->string('token');
            $table->timestamps();

            $table->foreign('basket_id')->references('id')->on('baskets');
            $table->foreign('basket_recovery_id')->references('id')->on('basket_recoveries')->onDelete('SET NULL');
            $table->index('basket_id');
            $table->index('basket_recovery_id');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('basket_recovery_logs');
        Schema::dropIfExists('basket_recovery_sent_emails');
        Schema::dropIfExists('basket_recoveries');
    }
}
