<?php

/**
 * @var \Illuminate\Routing\Router $router
 */

use Illuminate\Routing\Router;
use Mtc\BasketRecovery\Http\Controllers\RecoverBasketController;
use Mtc\BasketRecovery\Http\Controllers\ReadRecoveryEmailController;
use Mtc\BasketRecovery\Http\Controllers\Admin\BasketRecoveryController;
use Mtc\BasketRecovery\Http\Controllers\Admin\PreviewBasketRecoveryController;

/*
 * Front-end routes
 */
$router->get('recover-basket', RecoverBasketController::class)->name('basket-recovery.recover');
$router->get('basket-recovery.gif', ReadRecoveryEmailController::class)->name('basket-recovery.read');

/*
 * Admin specific routes, at the time or writing the WEB middleware should be avoided on admin routes.
 */
$router->group([
    'prefix' => 'admin/basket-recovery',
    'as' => 'admin.basket-recovery.',
    'middleware' => [
        'auth'
    ],
], function (Router $router) {
    $router->get('', BasketRecoveryController::class . '@index')->name('index');
    $router->get('create', BasketRecoveryController::class . '@create')->name('create');
    $router->post('', BasketRecoveryController::class . '@store')->name('store');
    $router->get('{basket_recovery}/edit', BasketRecoveryController::class . '@edit')->name('edit');
    $router->post('{basket_recovery}', BasketRecoveryController::class . '@update')->name('update');
    $router->delete('{basket_recovery}', BasketRecoveryController::class . '@destroy')->name('destroy');
    $router->get('{basket_recovery}/preview', PreviewBasketRecoveryController::class)->name('preview');
});
