<?php

namespace Mtc\BasketRecovery\Observers;

use Mtc\BasketRecovery\Models\BasketRecovery;
use Mtc\BasketRecovery\Models\BasketRecoveryEmail;

/**
 * Class BasketRecoveryObserver
 *
 * @package Mtc\BasketRecovery\Observers
 */
class BasketRecoveryObserver
{
    /**
     * @param \Mtc\BasketRecovery\Models\BasketRecovery $basket_recovery
     */
    public function deleted(BasketRecovery $basket_recovery)
    {
        BasketRecoveryEmail::query()
            ->where('basket_recovery_id', $basket_recovery->id)
            ->update([
                'basket_recovery_id' => null
            ]);
    }

}