<?php

/**
 * @var \Illuminate\Database\Eloquent\Factory $factory
 */

use Faker\Generator;
use Mtc\Basket\Basket;
use Mtc\BasketRecovery\Models\BasketRecovery;
use Mtc\BasketRecovery\Models\BasketRecoveryEmail;


$factory->define(Basket::class, function (Generator $faker) {
    return [

    ];
});

$factory->define(BasketRecovery::class, function (Generator $faker) {
    $measure = $faker->randomElement(BasketRecovery::getAllowedIntervals());
    return [
        'subject' => $faker->sentence,
        'content' => '<p>' . implode('</p><p>', $faker->paragraphs) . '</p>',
        'is_active' => $faker->boolean,
        'interval' => $interval = "{$faker->randomDigitNotNull} {$measure}",
        'interval_seconds' => strtotime("+{$interval}") - time()
    ];
});

$factory->define(BasketRecoveryEmail::class, function () {
    return [
        'basket_id' => function () {
            return factory(Basket::class)->create()->id;
        },
        'basket_recovery_id' => function () {
            return factory(BasketRecovery::class)->create()->id;
        },
        'token' => BasketRecoveryEmail::generateToken()
    ];
});


$factory->define(\Mtc\Orders\Order::class, function (Generator $faker) {

    return [
        'paid_at' => random_int(0, 2) ? \Carbon\Carbon::now()->subDays(random_int(0, 20)) : null,
        'reference' => str_random(20),
        'status_id' => random_int(0, 10),
        'cost_total' => random_int(0, 999999) / 100,
        'vat_rate' => array_rand(config('tax.vat_rates')),
        'email' => $faker->safeEmail,
        'contact_number' => $faker->phoneNumber,
        'secondary_phone_number' => random_int(0, 1) ? $faker->phoneNumber : null,
        'newsletter_signup' => random_int(0, 1),
    ];
});
