<?php

namespace Mtc\BasketRecovery\Events;

use Mtc\BasketRecovery\Models\BasketRecoveryEmail;

/**
 * Class BasketRecoveryNotificationEvent
 *
 * @package Mtc\BasketRecovery\Events
 */
class BasketRecoveryNotificationEvent
{

    /**
     * @var \Mtc\BasketRecovery\Models\BasketRecoveryEmail
     */
    protected $email;

    /**
     * BasketRecoveryNotificationEvent constructor.
     *
     * @param \Mtc\BasketRecovery\Models\BasketRecoveryEmail $email
     */
    public function __construct(BasketRecoveryEmail $email)
    {
        $this->email = $email;
    }

    /**
     * @return \Mtc\BasketRecovery\Models\BasketRecoveryEmail
     */
    public function getBasketRecoveryEmail()
    {
        return $this->email;
    }

}