<?php namespace Mtc\BasketRecovery\Http\Controllers;

use Illuminate\Routing\Controller;
use Mtc\BasketRecovery\Http\Requests\BasketRecoveryRequest;
use Mtc\BasketRecovery\Traits\CanRetrieveToken;

/**
 * Class BasketRecoveryController
 *
 * @package Mtc\BasketRecovery\Http\Controllers
 */
class RecoverBasketController extends Controller
{
    use CanRetrieveToken;

    /**
     * Recover the customers basket, if the request is valid return them to /basket, otherwise send them to the /
     *
     * @param \Mtc\BasketRecovery\Http\Requests\BasketRecoveryRequest $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke(BasketRecoveryRequest $request)
    {
        if (!$recovery_email = $this->getRecoveryEmailFromRequest($request)) {
            return redirect()->to($request->getRedirect());
        }

        $recovery_email->recordClick()->restoreBasket();
        return redirect()->route('basket.index');

    }

}