<?php

namespace Mtc\Basket\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Basket\Basket;

class BasketCreating
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Basket object
     *
     * @var Basket
     */
    public $basket;

    /**
     * Create a new event instance.
     *
     * @param Basket $basket basket data
     * @return void
     */
    public function __construct($basket)
    {
        $this->basket = $basket;
    }
}
