<?php

namespace Mtc\Basket\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class AddBasketItem
 *
 * @package Mtc\Basket\Http\Requests
 */
class AddBasketItem extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'node_id' => 'required|numeric|exists:nodes,id',
            'quantity' => 'required|numeric|min:1',
        ];
    }
}
